package ch.frankel.blog.loginmodule;

import java.security.Principal;

/**
 * A custom role principal.
 * 
 * @author Nicolas Frnkel
 * @since 3 avr. 2009
 */
public class PlainUserPrincipal implements Principal {

    /** Principal name. */
    private final String name;

    /**
     * Constructeur.
     * 
     * @param aName
     */
    public PlainUserPrincipal(String aName) {

        name = aName;
    }

    /**
     * @see java.security.Principal#getName()
     */
    @Override
    public String getName() {

        return name;
    }
}
